\" t
.\" ** The above line should force tbl to be a preprocessor **
.\" Man page for vncserver
.\"
.\" Copyright (C) 1998 Marcus.Brinkmann@ruhr-uni-bochum.de
.\" Copyright (C) 2000, opal@debian.org
.\" Copyright (C) 2000, 2001 Red Hat, Inc.
.\" Copyright (C) 2001, 2002 Constantin Kaplinsky
.\" Copyright (C) 2005-2006 Sun Microsystems, Inc.
.\" Copyright (C) 2010-2013, 2015 D. R. Commander
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file LICENCE.TXT that comes with the
.\" TightVNC distribution.
.\"
.TH vncserver 1 "September 2015" "" "TurboVNC"
.SH NAME
vncserver \- a wrapper to launch an X server for VNC.
.SH SYNOPSIS
\fBvncserver\fR
[:\fIdisplay\fR] [\-geometry \fIwidth\fRx\fIheight\fR] [\-depth \fIdepth\fR]
[\-pixelformat rgb\fINNN\fR|bgr\fINNN\fR] [\-fp \fIfont\-path\fR]
[\-name \fIdesktop\-name\fR] [\-nohttpd] [\-novncauth] [\-nootp]
[\-nopam] [\-noauth] [\-otp] [\-fg] [\-noxstartup]
[\-xstartup \fIscript\fR] [\fIXvnc\-options\fR...]
.TP
\fBvncserver\fR \-kill :\fIdisplay\fR
.TP
\fBvncserver\fR \-list
.TP
\fBvncserver\fR \-help
.SH DESCRIPTION
\fBvncserver\fR is a wrapper script for \fBXvnc\fR, the VNC (Virtual Network
Computing) X server. Xvnc provides all of the capabilities of a standard X
server, but it does not connect to a physical display. Instead, \fBXvnc\fR
creates a virtual X display that you can view or control remotely using a VNC
viewer.
.SH OPTIONS
You can add \fBXvnc\fR options to the \fBvncserver\fR command line. They will be
passed through to Xvnc without modification. The options provided by
\fBvncserver\fR itself are as follows:
.TP
\fB:\fR\fIdisplay\fR
The X display number that Xvnc should occupy. If omitted, the next free display number
is used.
.TP
\fB\-geometry\fR \fIwidth\fR\fBx\fR\fIheight\fR
Set width and height of the virtual X display.
.TP
\fB\-depth\fR \fIdepth\fR
Set the color depth of the virtual X display, in bits per pixel. Must
be a value between 8 and 32.
.TP
\fB\-pixelformat\fR \fBrgb\fR\fINNN\fR|\fBbgr\fR\fINNN\fR
Specify the pixel format of the virtual X display. Xvnc can use any pixel
format you choose, but if this pixel format does not match the pixel format
of the display on which vncviewer is running, then Xvnc will perform pixel
format conversion prior to sending images to vncviewer. This can slow
performance. The default pixel format, rgb888, is equivalent to BGRA on little
endian systems or ARGB on big endian systems.  A pixel format of bgr888 is
equivalent to RGBA on little endian systems or ABGR on big endian systems.
.TP
\fB\-fp\fR \fIfont-path\fR
The vncserver script will normally examine your system to figure out where it
stores its X11 fonts and then generate an appropriate font path for Xvnc based
on this.  If your system stores its X11 fonts in a location that vncserver does
not know about, however, then this may fail.  In that case, vncserver will then
try to contact the local X Font Server (xfs) on port 7100.  Not all systems
have xfs installed and running, so this may fail as well.  In that case, you
can manually specify a font path by using the -fp argument to vncserver.

If you prefer to use the X Font Server by default rather than a static font
path, then you can run

{TurboVNC_directory}/bin/vncserver -fp unix/:7100

on Linux systems or

{TurboVNC_directory}/bin/vncserver -fp inet/:7100

on Solaris systems.
.TP
\fB\-name\fR \fIstring\fR
This specifies the name of the desktop.
.TP
\fB\-nohttpd
The default behavior of the \fBvncserver\fR script is to enable the embedded
web server in Xvnc, which serves up the Java TurboVNC Viewer on a dedicated
port.  Passing an argument of -nohttpd to \fBvncserver\fR tells it not to enable
the embedded web server in Xvnc.
.TP
\fB\-novncauth\fR
The default behavior of the \fBvncserver\fR script is to enable all of the
supported authentication methods (VNC Password, One-Time Password, and PAM
User/Password) in Xvnc.  Passing an argument of \-novncauth to \fBvncserver\fR
tells it not to enable the VNC Password authentication method in Xvnc.  This
argument has no effect if \fIpermitted-auth-methods\fR is specified in the
authentication configuration file and "vnc" is not listed as a permitted
method.
.TP
\fB\-nootp\fR
The default behavior of the \fBvncserver\fR script is to enable all of the
supported authentication methods (VNC Password, One-Time Password, and PAM
User/Password) in Xvnc.  Passing an argument of \-nootp to \fBvncserver\fR
tells it not to enable the One-Time Password authentication method in Xvnc.
This argument has no effect if \fIpermitted-auth-methods\fR is specified in the
authentication configuration file and "otp" is not listed as a permitted
method.
.TP
\fB\-nopam\fR
The default behavior of the \fBvncserver\fR script is to enable all of the
supported authentication methods (VNC Password, One-Time Password, and PAM
User/Password) in Xvnc.  Passing an argument of \-nopam to \fBvncserver\fR
tells it not to enable the PAM User/Password authentication method in Xvnc.
Disabling this authentication method will prevent viewers from using Unix Login
authentication.  This command-line argument has no effect if
\fIpermitted-auth-methods\fR is specified in the authentication configuration
file and "pam-userpwd" is not listed as a permitted method.
.TP
\fB\-noauth\fR
The default behavior of the \fBvncserver\fR script is to enable all of the
supported authentication methods (VNC Password, One-Time Password, and PAM
User/Password) in Xvnc.  Passing an argument of \-noauth to \fBvncserver\fR
tells it to disable all forms of authentication in Xvnc.  If
\fIpermitted-auth-methods\fR is specified in the authentication configuration
file and "none" is not listed as a permitted method, then Xvnc exits with an
error.
.TP
\fB\-otp\fR
If the One-Time Password authentication method is enabled and permitted in
Xvnc, then this generates an initial one-time password and prints it to the
console prior to starting Xvnc.
.TP
\fB\-fg\fR
Runs Xvnc as a foreground process.  This has two effects: (1) The VNC server
can be aborted with CTRL-C, and (2) the VNC server will exit as soon as the
user logs out of the window manager in the VNC session.  This may be necessary
when launching TurboVNC from within certain grid computing environments.
.TP
\fB\-noxstartup\fR
Do not run the $vncUserDir/.vnc/xstartup.turbovnc script after launching Xvnc.  This
option allows you to manually start a window manager in your TurboVNC session
or to run a full-screen application without a window manager.
.TP
\fB\-xstartup\fR \fIscript\fR
Run a custom startup script, instead of xstartup.turbovnc, after launching
Xvnc.  This is useful in conjunction with the \fB-fg\fR option, since it
allows for running a full-screen application (such as a game or a
virtualization solution) in TurboVNC without a window manager and causes the
TurboVNC session to terminate whenever the application exits.
.TP
\fB\-log\fR  \fIfile\fR
Redirect the output of Xvnc to \fIfile\fR, rather than to
$vncUserDir/.vnc/{hostname}{display}.log.
.TP
\fB\-kill\fR \fB:\fR\fIdisplay\fR
Stops the VNC server that is currently running on the specified display.
.TP
\fB\-list\fR
Lists the display numbers and process ID's of all VNC servers that are
currently running under your account on this machine.
.TP
\fB\-help\fR
Prints a brief list of command line options
.SH EXAMPLES
.TP
\fBvncserver\fR
Starts \fBXvnc\fR on the next available display and uses suitable
defaults.
.TP
\fBvncserver\fR \fI:1\fR
Starts \fBXvnc\fR on display :1.
.TP
\fBvncserver\fR -geometry \fI1024x768 :1\fR
Starts \fBXvnc\fR on display :1 with desktop size of 1024x768 pixels.
.TP
\fBvncserver\fR -kill \fI:1\fR
Shuts down the \fBXvnc\fR server running on display :1.
.SH FILES
.TP
/etc/turbovncserver.conf
System-wide configuration file for the TurboVNC Server.
.TP
$HOME/.vnc/turbovncserver.conf
User configuration file for the TurboVNC Server. Settings in this file
override the system-wide configuration.
.SH SEE ALSO
\fBXvnc\fR(1), \fBvncviewer\fR(1), \fBvncpasswd\fR(1), \fBvncconnect\fR(1)
.SH AUTHORS
VNC was originally developed at AT&T Laboratories Cambridge. TightVNC
additions were implemented by Constantin Kaplinsky. TurboVNC, based
on TightVNC, is provided by The VirtualGL Project. Many other people
participated in development, testing and support.

\fBMan page authors:\fR
.br
Marcus Brinkmann <Marcus.Brinkmann@ruhr-uni-bochum.de>,
.br
Tim Waugh <twaugh@redhat.com>,
.br
Constantin Kaplinsky <const@tightvnc.com>
.br
D. R. Commander <information@turbovnc.org>
